function P83_vi
% Problem 8.3 :	Double-Well Potential System
% vi. Plot the color-coded grids 
%     for different initial conditions. 

% Define number of steps
nx=50; ny=50;
% Define range of initial conditions
mx=2.5; my=2.5;
% Generate full range of initial conditions
x=[-nx:nx]/nx*mx;
y=[-ny:ny]/ny*my;
% Define Grid (101 X 101)
o=zeros(length(x),length(y));
% Calculate the final position o particle,
% depending on the initial conditions
for i=1:length(x)
    for j=1:length(y)
        % Set initial condition
        x0=[x(i);y(j)];
        % Calculate trajectory of particle 
        [T,X]=ode45(@DoubleWell,[0,500],x0);
        % Determine which well the particle stays finally
        o(i,j)=sign(X(end,1));
    end
end
% Plot grid as an image with color code
% Swap row and column (Matrix transpose)
o=o';
imagesc(o);
axis image; 
set(gca,'YDir','normal')
set(gca,'XTick',[1:10:101])
set(gca,'XTickLabel',[-2.5:0.5:2.5])
set(gca,'YTick',[1:10:101])
set(gca,'YTickLabel',[-2.5:0.5:2.5])
set(gca,'FontSize',20);
set(gca,'FontWeight','bold');
xlabel('\bfInitial Position (x_0)');
ylabel('\bfInitial Velocity (v_0)');
title('\bfInitial Condition Sensitivity in the Color-Coded Grid');
end

function dx=DoubleWell(t,x)
% Describe euation of motion
% in the double-well potetial system
dx(1,1)=x(2);
dx(2,1)=0.25*cos(t)-0.25*x(2)+x(1)-x(1)^3;
end